/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.mixin.lightsource;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.thinkingstudio.ryoamiclights.DynamicLightSource;
import org.thinkingstudio.ryoamiclights.DynamicLightsMode;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandlers;

@Mixin(value={class_2586.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected class_2338 field_11867;
    @Shadow
    @Nullable
    protected class_1937 field_11863;
    @Shadow
    protected boolean field_11865;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet ryoamiclights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double ryoamicLights$getDynamicLightX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    @Override
    public class_1937 ryoamicLights$getDynamicLightWorld() {
        return this.field_11863;
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.ryoamicLights$setDynamicLightEnabled(false);
    }

    @Override
    public void ryoamicLights$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void ryoamicLights$dynamicLightTick() {
        if (this.field_11863 == null || !this.field_11863.method_8608()) {
            return;
        }
        if (!this.field_11865) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((class_2586)this);
            RyoamicLights.updateTracking(this);
            if (!this.ryoamicLights$isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int ryoamicLights$getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean ryoamicLights$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = RyoamicLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean ryoamiclights$updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.ryoamicLights$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.ryoamicLights$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.ryoamiclights$trackedLitChunkPos.isEmpty()) {
                class_2338.class_2339 chunkPos = new class_2338.class_2339(class_3532.method_48116((int)this.field_11867.method_10263(), (int)16), class_3532.method_48116((int)this.field_11867.method_10264(), (int)16), class_3532.method_48116((int)this.field_11867.method_10260(), (int)16));
                RyoamicLights.updateTrackedChunks((class_2338)chunkPos, null, this.ryoamiclights$trackedLitChunkPos);
                class_2350 directionX = (this.field_11867.method_10263() & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (this.field_11867.method_10264() & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (this.field_11867.method_10260() & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.method_10098(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.method_10098(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.method_10098(directionX.method_10153());
                    } else {
                        chunkPos.method_10098(directionZ.method_10153());
                        chunkPos.method_10098(directionY);
                    }
                    RyoamicLights.updateTrackedChunks((class_2338)chunkPos, null, this.ryoamiclights$trackedLitChunkPos);
                }
            }
            this.ryoamiclights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void ryoamiclights$scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        if (this.field_11863 == class_310.method_1551().field_1687) {
            LongIterator longIterator = this.ryoamiclights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                RyoamicLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

